//
//  FirstViewController.m
//  ComAir5
//
//  Created by generalplus_sa1 on 10/22/14.
//  Copyright (c) 2014 generalplus_sa1. All rights reserved.
//

#import "FirstViewController.h"
#import <AVFoundation/AVFoundation.h>
#import <AudioToolbox/AudioToolbox.h>
#import <QuartzCore/QuartzCore.h>
#import "ComAir5API.h"
#import "LogFileHandler.h"

#define SAVERAW_USER_KEY             @"SaveRawData"
#define DEFAULT_SAVERAW              FALSE

FirstViewController *pMainUI = NULL;

//------------------------------------------------------------------------------
@interface FirstViewController ()
{
    int                 m_i32Count;
    LogFileHandler      *m_pLogHandler;
    BOOL                m_bSaveRawData;
    AVAudioPlayer       *m_audioPlayer;
}

@property (retain, nonatomic) IBOutlet UIActivityIndicatorView *UIActiveRec;
@property (retain, nonatomic) IBOutlet UITextView *UITFCmdHistory;
@property (retain, nonatomic) IBOutlet UILabel *UICmdValue;
@property (retain, nonatomic) IBOutlet UIButton *UIBtnShowHistory;
@property (retain, nonatomic) IBOutlet UISwitch *UISwitchSaveRaw;
@property (retain, nonatomic) IBOutlet UISegmentedControl *UISegRecordStart;
@property (retain, nonatomic) IBOutlet UILabel *UIVersion;

@end
//------------------------------------------------------------------------------

@implementation FirstViewController

@synthesize UICmdValue,UIActiveRec,UITFCmdHistory,UIBtnShowHistory,UISwitchSaveRaw,UISegRecordStart,UIVersion;
//-----------------------------------------------------------------
int UserCallBack(int Command)
{
    FirstViewController *pUIController = (FirstViewController *)pMainUI;
    
    if(Command!=-1)
    {
        NSNumber *nCommand = [[NSNumber alloc]initWithInt:Command];
        [pUIController performSelectorOnMainThread:@selector(AppendCmd:)
                                        withObject:nCommand
                                     waitUntilDone:YES];
        
    }
    
    
    return 0;
}
//-----------------------------------------------------------------
int UserRawDataCallBack(unsigned char* pbyRawData,int i32Size)
{
    
    FirstViewController *pUIController = (FirstViewController *)pMainUI;
    
    if(pUIController->m_bSaveRawData)
        [pUIController->m_pLogHandler WriteFile:pbyRawData WithSize:i32Size];
    
    return 0;
}
//-----------------------------------------------------------------
-(IBAction)PressSaveRaw:(id)sender
{
    UISwitch *pSwitch = (UISwitch*)sender;
    
    if([pSwitch isOn] == TRUE)
    {
        m_bSaveRawData = TRUE;
    }
    else
    {
        m_bSaveRawData = FALSE;
    }
    
    [[NSUserDefaults standardUserDefaults] setBool:[pSwitch isOn] forKey:SAVERAW_USER_KEY];
}
//-----------------------------------------------------------------
-(IBAction)PressStartSel:(id)sender
{
    UISegmentedControl *Sel = (UISegmentedControl*)sender;
    
    if([Sel selectedSegmentIndex] == 0)
    {
        [UIActiveRec stopAnimating];
        StopComAir5Decode();
        
        UIBtnShowHistory.enabled = TRUE;
        UIBtnShowHistory.alpha = 1.0;
    }
    else
    {
        [m_pLogHandler RemoveLogFiles];
        
        [UIActiveRec startAnimating];
        StartComAir5Decode();
        m_i32Count = 0;
        UITFCmdHistory.text = @"";
        UICmdValue.text=@"";
        
        UIBtnShowHistory.enabled = FALSE;
        UIBtnShowHistory.alpha = 0.5;
    }
}
//-----------------------------------------------------------------
-(IBAction)PressShowHistory:(id)sender
{
    if(!m_bSaveRawData)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Show Command History"
                                                        message:@"Command History only available when Save Raw is on,\nPlease turn on before Start!"
                                                       delegate:self
                                              cancelButtonTitle:@"OK"
                                              otherButtonTitles:nil];
        
        [alert show];
    }
    
    UITFCmdHistory.text = [m_pLogHandler GetLogString];
}
//-----------------------------------------------------------------
-(bool)	AppendCmd:(NSNumber *)Command
{
    m_i32Count++;
    NSString *FoundCmd = [NSString stringWithFormat:@"[%d]Command: %d\r\n",m_i32Count, [Command intValue]];
    
    UICmdValue.text = FoundCmd;
    
    if(m_bSaveRawData)
        [m_pLogHandler LogCommand:FoundCmd];
    
    
    if(m_audioPlayer!=nil)
    {
        m_audioPlayer = nil;
    }
    
    //if([Command intValue] <= 63)
    {
        NSString *SoundIndex = [[NSString alloc]initWithFormat:@"n%d",[Command intValue]];
        
        NSString *soundFilePath = [[NSBundle mainBundle] pathForResource: SoundIndex ofType: @"wav"];
        
        NSURL *fileURL = [[NSURL alloc] initFileURLWithPath: soundFilePath];
        m_audioPlayer = [[AVAudioPlayer alloc]initWithContentsOfURL:fileURL error: nil];
        m_audioPlayer.numberOfLoops = 0;
        [m_audioPlayer play];
        
    }
    
    return true;
}
//-----------------------------------------------------------------
-(void)ReadUserSetting
{
    
    id SaveRawObject  = [[NSUserDefaults standardUserDefaults] objectForKey:SAVERAW_USER_KEY];
    if(SaveRawObject)
    {
        
        UISwitchSaveRaw.On = [[NSUserDefaults standardUserDefaults] boolForKey:SAVERAW_USER_KEY];
    }
    else
    {
        UISwitchSaveRaw.On = DEFAULT_SAVERAW;
    }
    
    [self PressSaveRaw:UISwitchSaveRaw];
    
}
//------------------------- ----------------------------------------
- (void)viewWillAppear:(BOOL)animated
{
    [self PressStartSel:UISegRecordStart];
    
    [super viewWillAppear:animated];
}
//-----------------------------------------------------------------
- (void)HandleDidBecomeActiveNotification
{
    printf("HandleDidBecomeActiveNotification\n");
    if([UISegRecordStart selectedSegmentIndex] == 1) //Recording
    {
        double delayInSeconds = 2.0;
        dispatch_time_t popTime = dispatch_time(DISPATCH_TIME_NOW, delayInSeconds * NSEC_PER_SEC);
        dispatch_after(popTime, dispatch_get_main_queue(), ^(void){
            //code to be executed on the main queue after delay
            StopComAir5Decode();
            StartComAir5Decode();
        });
        
    }
}
//-----------------------------------------------------------------
- (void)viewDidLoad
{
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    
    //route audio output to speaker
    [[AVAudioSession sharedInstance] setCategory:AVAudioSessionCategoryPlayAndRecord error:nil];

    [[AVAudioSession sharedInstance]setMode:AVAudioSessionModeMeasurement error:nil];
    
    //set the audioSession override
    NSError* error;
    BOOL success = [[AVAudioSession sharedInstance] overrideOutputAudioPort:AVAudioSessionPortOverrideSpeaker
                                                                 error:&error];
    if (!success)  NSLog(@"AVAudioSession error overrideOutputAudioPort:%@",error);
    
    [[AVAudioSession sharedInstance] setActive:YES error:nil];
    [[UIApplication sharedApplication]setIdleTimerDisabled:YES];
    
    int i32Freq;
    GetComAir5Property(eComAir5PropertyTarget_Decode,eComAir5Property_CentralFreq,&i32Freq,sizeof(i32Freq));
    
    pMainUI = self;
    
    PFN_UserCallBack UserCallBackfp = &UserCallBack;
    SetComAir5Property(eComAir5PropertyTarget_Decode,eComAir5Property_CmdCallBack,&UserCallBackfp,sizeof(PFN_UserCallBack));
    
    PFN_UserRawDataCallBack UserRawCallBackfp = &UserRawDataCallBack;
    SetComAir5Property(eComAir5PropertyTarget_Decode,eComAir5Property_RawDataCallBack,&UserRawCallBackfp,sizeof(PFN_UserRawDataCallBack));
    
    InitComAir5();
    
    
    m_i32Count= 0;
    UITFCmdHistory.layer.borderColor = [UIColor grayColor].CGColor;
    UITFCmdHistory.layer.borderWidth = 1.0f;
    
    m_bSaveRawData = FALSE;
    
    UIBtnShowHistory.enabled = TRUE;
    UIBtnShowHistory.alpha = 1.0;
    
    m_pLogHandler = [[LogFileHandler alloc]init];
    
    m_audioPlayer= nil;
    
    UIVersion.text = [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"];
    
    [self ReadUserSetting];
    [self CheckMicPrivacy];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(HandleDidBecomeActiveNotification)
                                                 name:UIApplicationDidBecomeActiveNotification
                                               object:nil];
    
}
//-----------------------------------------------------------------
- (void)CheckMicPrivacy
{
    
    NSString *currSysVer = [[UIDevice currentDevice] systemVersion];
    if ([currSysVer compare:@"7.0" options:NSNumericSearch] != NSOrderedAscending)
    {
        AVAudioSession *session = [[AVAudioSession alloc] init];
        [session requestRecordPermission:^(BOOL granted) {
            if(granted) {
                NSError *error;
                /*
                 Setting the category will also request access from the user
                 */
                [session setCategory:@"AVAudioSessionCategoryPlayAndRecord" error:&error];
                
                /*
                 Do something with the audio session
                 */
            }
            else {
                /*
                 Handle failure
                 */
            }
            
            if(!granted)
            {
                
                dispatch_async(dispatch_get_main_queue(), ^{
                    
                    NSString *message = [NSString stringWithFormat:@"Microphone Privacy is been disabled\nPlease turn on the privacy in \n\"Settings > Privacy > Microphone\""];
                    UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Microphone Privacy"
                                                                        message:message delegate:nil
                                                              cancelButtonTitle:@"OK"
                                                              otherButtonTitles:nil];
                    [alertView show];
                    alertView = nil;
                    
                });
                
            }
        }];
        
    }
    
}
//-----------------------------------------------------------------
- (void)alertMicView:(BOOL)bGranted {
    
    if(!bGranted)
    {
        NSString *message = [NSString stringWithFormat:@"Mic is disable"];
        UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Require Mic"
                                                            message:message delegate:nil
                                                  cancelButtonTitle:@"OK"
                                                  otherButtonTitles:nil];
        [alertView show];
        alertView = nil;
    }
}

//-----------------------------------------------------------------
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}
//-----------------------------------------------------------------
- (BOOL)prefersStatusBarHidden {
    
    return true;
}
//-----------------------------------------------------------------
@end
